/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.storage.USMDevInfoException;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.util.GenericUtil;
import oracle.ops.verification.util.ParsingException;

public class USMDevInfo {
    private String m_name;
    private String m_owner;
    private String m_group;
    private String m_perms;
    private String m_devline;
    private String TAG_USMDEVICE = "USMDEVICE";
    private String TAG_USMNAME = "USMDEV_NAME";
    private String TAG_USMOWNER = "USMDEV_OWNER";
    private String TAG_USMGROUP = "USMDEV_GROUP";
    private String TAG_USMPERMS = "USMDEV_PERMS";
    private String TAG_USMDEVLN = "USMDEV_LINE";
    static final String LSEP = System.getProperty("line.separator");

    public boolean parse(String usmdevOutput) throws USMDevInfoException {
        String[] usmdevFields;
        String[] usmTags = new String[]{this.TAG_USMDEVLN, this.TAG_USMNAME, this.TAG_USMOWNER, this.TAG_USMGROUP, this.TAG_USMPERMS};
        Trace.out((int)2, (String)"Entry");
        try {
            usmdevFields = GenericUtil.getFieldsByTags(usmdevOutput, usmTags);
        }
        catch (ParsingException e) {
            Trace.out((int)5, (String)("ParsingException " + e));
            throw new USMDevInfoException(e);
        }
        if (usmdevFields.length <= 3) {
            Trace.out((int)5, (String)("Error parsing device output :" + usmdevOutput));
            return false;
        }
        Trace.out((int)5, (String)("Parsing successful for dev output string:" + usmdevOutput + LSEP + "DevLine=" + usmdevFields[0] + "\nName=" + usmdevFields[1] + " Owner=" + usmdevFields[2] + "\nGroup=" + usmdevFields[3] + " Perms=" + usmdevFields[4]));
        this.m_devline = usmdevFields[0];
        this.m_name = usmdevFields[1];
        this.m_owner = usmdevFields[2];
        this.m_group = usmdevFields[3];
        this.m_perms = usmdevFields[4];
        return true;
    }

    public boolean match(String inpath) {
        String output;
        if (inpath.equals(this.m_name)) {
            return true;
        }
        String pattn = this.m_name.replaceAll("\\*", "\\\\w");
        Pattern pattern = Pattern.compile(pattn);
        String matchstr = inpath.replaceFirst("/dev/", "");
        VerificationLogData.logInfo("\ninpath: '" + inpath + "' matchstr: '" + matchstr + "'");
        Trace.out((String)("inpath: '" + inpath + "' matchstr: '" + matchstr + "'"));
        Matcher matcher = pattern.matcher(matchstr);
        if (matcher.matches()) {
            VerificationLogData.logInfo("\nMATCH FOUND inpath: '" + inpath + "' matchstr: '" + matchstr + "' Pattern: '" + pattn + "'");
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("\nMATCH FOUND inpath: '" + inpath + "' matchstr: '" + matchstr + "' Pattern: '" + pattn + "'"));
            }
            return true;
        }
        VerificationLogData.logInfo("\nChecking matchstr: '" + matchstr + "' against the UDEV spec: '" + this.m_name + "' using exectask's fnmatch() check");
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\nChecking matchstr: '" + matchstr + "' against the UDEV spec: '" + this.m_name + "' using exectask's fnmatch() check"));
        }
        ResultSet resultSet = new ResultSet();
        VerificationCommand[] udevMatchCmdArray = new VerificationCommand[1];
        String[] arg = new String[1];
        String[] env = null;
        arg[0] = new String("-fnmatch \"" + this.m_name + "\" " + matchstr + " ");
        Trace.out((int)5, (String)("Calling exectask command: '" + arg[0] + "'"));
        udevMatchCmdArray[0] = new VerificationCommand("localnode", arg, env);
        new GlobalHandler().submit((Command[])udevMatchCmdArray, 0, resultSet);
        if (!resultSet.anySuccess()) {
            VerificationLogData.logError("exectask fnmatch for dev: '" + inpath + "' failed.");
            Trace.out((int)5, (String)"Global failure executing -fnmatch command. ");
            return false;
        }
        Trace.out((int)5, (String)"Processing -fnmatch command output");
        VerificationCommand udevMatchCmd = udevMatchCmdArray[0];
        Result result = udevMatchCmd.getResult();
        Trace.out((int)5, (String)("-fnmatch command output:\nVfyCode: " + udevMatchCmd.getVfyCode() + "\nStatus: " + result.getStatus() + "\nOutput: " + udevMatchCmd.getOutput() + "\n"));
        VerificationLogData.logInfo("-fnmatch command output:\nVfyCode: " + udevMatchCmd.getVfyCode() + "\nStatus: " + result.getStatus() + "\nOutput: " + udevMatchCmd.getOutput() + "\n");
        if (udevMatchCmd.getVfyCode() == 0 && result.getStatus() == 1 && (output = udevMatchCmd.getOutput()).contentEquals("MATCH")) {
            VerificationLogData.logInfo("match FOUND");
            return true;
        }
        VerificationLogData.logInfo("match NOT found");
        return false;
    }

    public String getName() {
        return this.m_name;
    }

    public String getOwner() {
        return this.m_owner;
    }

    public String getGroup() {
        return this.m_group;
    }

    public String getPerms() {
        return this.m_perms;
    }

    public String getDevLine() {
        return this.m_devline;
    }

    public String getFile() {
        if (this.m_devline.indexOf("KERNEL") != -1) {
            return this.m_devline.substring(0, this.m_devline.indexOf("KERNEL") - 1);
        }
        return this.m_devline;
    }

    public String getRule() {
        if (this.m_devline.indexOf("KERNEL") != -1) {
            return this.m_devline.substring(this.m_devline.indexOf("KERNEL"));
        }
        return new String("<UNKNOWN>");
    }

    public String toString() {
        return "\nm_devline: " + this.m_devline + "\nm_name: " + this.m_name + " m_owner: " + this.m_owner + " m_group: " + this.m_group + " m_perms: " + this.m_perms;
    }
}

